/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsbuilder.shapes;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import mcjty.lib.varia.ComponentFactory;
import mcjty.lib.varia.LevelTools;
import mcjty.lib.varia.Logging;
import mcjty.lib.worlddata.AbstractWorldData;
import mcjty.rftoolsbuilder.modules.scanner.ScannerConfiguration;
import mcjty.rftoolsbuilder.shapes.Scan;
import mcjty.rftoolsbuilder.shapes.ScanExtraData;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class ScanDataManager
extends AbstractWorldData<ScanDataManager> {
    private static final String SCANDATA_NETWORK_NAME = "RFToolsScanData";
    private int lastId = 0;
    private final Map<Integer, Scan> scans = new HashMap<Integer, Scan>();
    private final Map<Integer, ScanExtraData> scanData = new HashMap<Integer, ScanExtraData>();

    public ScanDataManager() {
    }

    public ScanDataManager(CompoundTag tag) {
        this.scans.clear();
        ListTag lst = tag.getList("scans", 10);
        for (int i = 0; i < lst.size(); ++i) {
            CompoundTag tc = lst.getCompound(i);
            int id = tc.getInt("scan");
            Scan scan = new Scan();
            scan.readFromNBT(tc);
            this.scans.put(id, scan);
        }
        this.lastId = tag.getInt("lastId");
    }

    public void save(Level w, int scanId) {
        ServerLevel world = LevelTools.getOverworld((Level)w);
        File dataDir = null;
        dataDir.mkdirs();
        File file = new File(dataDir, "scan" + scanId);
        Scan scan = this.getOrCreateScan(scanId);
        CompoundTag tc = new CompoundTag();
        scan.writeToNBTExternal(tc);
        try (DataOutputStream dataoutputstream = new DataOutputStream(new FileOutputStream(file));){
            NbtIo.writeCompressed((CompoundTag)tc, (OutputStream)dataoutputstream);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Error writing to file 'scan" + String.valueOf(scan) + "'!", e);
        }
        this.save();
    }

    public ScanExtraData getExtraData(int id) {
        ScanExtraData data = this.scanData.get(id);
        if (data == null) {
            data = new ScanExtraData();
            this.scanData.put(id, data);
        } else if (data.getBirthTime() + (long)((Integer)ScannerConfiguration.ticksPerLocatorScan.get() * 100) < System.currentTimeMillis()) {
            data = new ScanExtraData();
            this.scanData.put(id, data);
        }
        return data;
    }

    public static ScanDataManager get(Level world) {
        return (ScanDataManager)ScanDataManager.getData((Level)world, ScanDataManager::new, ScanDataManager::new, (String)SCANDATA_NETWORK_NAME);
    }

    @Nonnull
    public Scan getOrCreateScan(int id) {
        Scan scan = this.scans.get(id);
        if (scan == null) {
            scan = new Scan();
            this.scans.put(id, scan);
        }
        return scan;
    }

    @Nonnull
    public Scan loadScan(Level w, int id) {
        ServerLevel world = LevelTools.getOverworld((Level)w);
        Scan scan = this.scans.get(id);
        if (scan == null || scan.getDataInt() == null) {
            if (scan == null) {
                scan = new Scan();
            }
            File dataDir = null;
            dataDir.mkdirs();
            File file = new File(dataDir, "scan" + id);
            if (file.exists()) {
                try (DataInputStream datainputstream = new DataInputStream(new FileInputStream(file));){
                    CompoundTag tag = NbtIo.readCompressed((InputStream)datainputstream, (NbtAccounter)NbtAccounter.unlimitedHeap());
                    scan.readFromNBTExternal(tag);
                }
                catch (IOException e) {
                    Logging.log((String)("Error reading scan file for id: " + id));
                }
            }
        }
        return scan;
    }

    public static void listScans(Player sender) {
        ScanDataManager scans = ScanDataManager.get(sender.getCommandSenderWorld());
        for (Map.Entry<Integer, Scan> entry : scans.scans.entrySet()) {
            Integer scanid = entry.getKey();
            scans.loadScan(sender.getCommandSenderWorld(), scanid);
            Scan scan = entry.getValue();
            BlockPos dim = scan.getDataDim();
            if (dim == null) {
                sender.sendSystemMessage((Component)ComponentFactory.literal((String)(String.valueOf(ChatFormatting.YELLOW) + "Scan: " + String.valueOf(ChatFormatting.WHITE) + scanid + String.valueOf(ChatFormatting.RED) + "   Invalid")));
                continue;
            }
            sender.sendSystemMessage((Component)ComponentFactory.literal((String)(String.valueOf(ChatFormatting.YELLOW) + "Scan: " + String.valueOf(ChatFormatting.WHITE) + scanid + String.valueOf(ChatFormatting.YELLOW) + "   Dim: " + String.valueOf(ChatFormatting.WHITE) + dim.getX() + "," + dim.getY() + "," + dim.getZ() + String.valueOf(ChatFormatting.YELLOW) + "   Size: " + String.valueOf(ChatFormatting.WHITE) + scan.getRledata().length + " bytes")));
        }
    }

    public int newScan(Level world) {
        ++this.lastId;
        this.save();
        return this.lastId;
    }

    public CompoundTag save(CompoundTag tagCompound, HolderLookup.Provider provider) {
        ListTag lst = new ListTag();
        for (Map.Entry<Integer, Scan> entry : this.scans.entrySet()) {
            CompoundTag tc = new CompoundTag();
            tc.putInt("scan", entry.getKey().intValue());
            entry.getValue().writeToNBT(tc);
            lst.add((Object)tc);
        }
        tagCompound.put("scans", (Tag)lst);
        tagCompound.putInt("lastId", this.lastId);
        return tagCompound;
    }
}

