/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolspower.modules.endergenic.data;

import mcjty.lib.varia.BlockPosTools;
import mcjty.lib.varia.Logging;
import mcjty.rftoolspower.modules.endergenic.blocks.EndergenicTileEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class EndergenicPearl {
    private int ticksLeft;
    private final BlockPos destination;
    private final int age;

    public EndergenicPearl(int ticksLeft, BlockPos destination, int age) {
        this.ticksLeft = ticksLeft;
        this.destination = destination;
        this.age = age;
    }

    public EndergenicPearl(CompoundTag tagCompound) {
        this.ticksLeft = tagCompound.getInt("t");
        this.destination = BlockPosTools.read((CompoundTag)tagCompound, (String)"dest");
        this.age = tagCompound.getInt("age");
    }

    public int getTicksLeft() {
        return this.ticksLeft;
    }

    public int getAge() {
        return this.age;
    }

    public BlockPos getDestination() {
        return this.destination;
    }

    public boolean handleTick(Level world) {
        --this.ticksLeft;
        if (this.ticksLeft <= 0) {
            BlockEntity te = world.getBlockEntity(this.destination);
            if (te instanceof EndergenicTileEntity) {
                EndergenicTileEntity endergenic = (EndergenicTileEntity)te;
                endergenic.receivePearl(this.age);
            } else {
                Logging.log((String)"Pearl: where did the destination go?");
            }
            return true;
        }
        return false;
    }

    public CompoundTag getTagCompound() {
        CompoundTag tagCompound = new CompoundTag();
        tagCompound.putInt("t", this.ticksLeft);
        BlockPosTools.write((CompoundTag)tagCompound, (String)"dest", (BlockPos)this.destination);
        tagCompound.putInt("age", this.age);
        return tagCompound;
    }
}

