/*
 * Decompiled with CFR 0.152.
 */
package com.razznature.decocraft.common.containers;

import com.razznature.decocraft.common.ModuleScreenHandlers;
import com.razznature.decocraft.common.items.DecoBlockItem;
import com.razznature.decocraft.common.tileentities.DecomposerTileEntity;
import com.razznature.mods.Mods;
import java.util.Map;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class DecomposerScreenHandler
extends AbstractContainerMenu {
    private static final int SPACING = 18;
    private static final int INVENTORY_X = -26;
    private static final int INVENTORY_Y = 117;
    public final NonNullList<ItemStack> items = NonNullList.create();
    private final ContainerLevelAccess context;
    public int[] crafting = new int[2];
    public int[] fuel = new int[1];
    private DecomposerTileEntity decomposerTE;
    private Level world;

    public DecomposerScreenHandler(int syncId, Inventory inventory) {
        this(syncId, inventory, ContainerLevelAccess.NULL);
    }

    public DecomposerScreenHandler(int syncId, Inventory inventory, ContainerLevelAccess context) {
        super((MenuType)ModuleScreenHandlers.DECOMPOSER.get(), syncId);
        this.context = context;
        this.context.execute((world, pos) -> {
            BlockEntity blockEntity = world.getBlockEntity(pos);
            this.decomposerTE = blockEntity instanceof DecomposerTileEntity ? (DecomposerTileEntity)blockEntity : null;
            this.world = world;
        });
        for (int i = 0; i < 9; ++i) {
            this.addSlot(new Slot((Container)inventory, i, -26 + i * 18, 117));
        }
        this.addSlot(new Slot(this, (Container)(this.decomposerTE == null ? new SimpleContainer(1) : this.decomposerTE.getInput()), 0, 28, 38){

            public boolean mayPlace(ItemStack stack) {
                if (stack == ItemStack.EMPTY) {
                    return false;
                }
                if (stack.getItem() == Items.COAL || stack.getItem() == Items.CHARCOAL) {
                    return true;
                }
                if (stack.getItem() == Items.WHEAT_SEEDS || stack.getItem() == Items.BEETROOT_SEEDS || stack.getItem() == Items.MELON_SEEDS || stack.getItem() == Items.PUMPKIN_SEEDS || stack.getItem() == Items.POTATO || stack.getItem() == Items.CARROT || stack.getItem() == Items.COCOA_BEANS || stack.getItem() == Items.KELP || stack.getItem() == Items.SWEET_BERRIES || stack.getItem() == Items.GLOW_BERRIES) {
                    return true;
                }
                boolean found = stack.getItem() instanceof DecoBlockItem;
                if (!found) {
                    for (Map.Entry<String, Integer> entry : Mods.DECOMPOSER_INGREDIENTS.entrySet()) {
                        if (entry.getKey().startsWith("#")) {
                            TagKey tag = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.parse((String)entry.getKey().substring(1)));
                            if (!stack.is(tag)) continue;
                            found = true;
                            break;
                        }
                        Item targetItem = (Item)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)entry.getKey()));
                        if (stack.getItem() != targetItem) continue;
                        found = true;
                        break;
                    }
                }
                return found;
            }
        });
        this.addSlot(new Slot((Container)(this.decomposerTE == null ? new SimpleContainer(1) : this.decomposerTE.getResult()), 0, 63, 38){

            public boolean mayPlace(ItemStack stack) {
                return false;
            }

            public void onTake(Player player, ItemStack stack) {
                super.onTake(player, stack);
                if (DecomposerScreenHandler.this.decomposerTE != null) {
                    DecomposerScreenHandler.this.decomposerTE.setChanged();
                }
            }
        });
        this.addSlot(new Slot(this, (Container)(this.decomposerTE == null ? new SimpleContainer(1) : this.decomposerTE.getFuel()), 0, 10, 84){

            public boolean mayPlace(ItemStack stack) {
                return stack.getItem() == Items.BONE_MEAL;
            }
        });
        this.addDataSlot(new DataSlot(){

            public int get() {
                return DecomposerScreenHandler.this.decomposerTE != null ? DecomposerScreenHandler.this.decomposerTE.getCraft() : 0;
            }

            public void set(int value) {
                DecomposerScreenHandler.this.crafting[0] = value;
            }
        });
        this.addDataSlot(new DataSlot(){

            public int get() {
                return DecomposerScreenHandler.this.decomposerTE != null ? DecomposerScreenHandler.this.decomposerTE.getCraftingTimer() : 0;
            }

            public void set(int value) {
                DecomposerScreenHandler.this.crafting[1] = value;
            }
        });
        this.addDataSlot(new DataSlot(){

            public int get() {
                return DecomposerScreenHandler.this.decomposerTE != null ? DecomposerScreenHandler.this.decomposerTE.getCurrentFuel() : 0;
            }

            public void set(int value) {
                DecomposerScreenHandler.this.fuel[0] = value;
            }
        });
        this.getTEData();
    }

    private void getTEData() {
        if (this.world != null && !this.world.isClientSide() && this.decomposerTE != null) {
            this.crafting[0] = this.decomposerTE.getCraft();
            this.crafting[1] = this.decomposerTE.getCraftingTimer();
            this.fuel[0] = this.decomposerTE.getCurrentFuel();
        }
    }

    public boolean stillValid(Player player) {
        return (Boolean)this.context.evaluate((world, pos) -> player.distanceToSqr((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5) <= 64.0, (Object)true);
    }

    public void removed(Player player) {
        super.removed(player);
        if (this.decomposerTE != null) {
            this.decomposerTE.setChanged();
        }
    }

    public void clicked(int slotId, int button, ClickType clickType, Player player) {
        if (slotId < 0 || slotId >= this.slots.size()) {
            if (!player.containerMenu.getCarried().isEmpty()) {
                ItemStack carried = player.containerMenu.getCarried();
                if (!player.getInventory().add(carried)) {
                    return;
                }
                player.containerMenu.setCarried(ItemStack.EMPTY);
            }
            return;
        }
        super.clicked(slotId, button, clickType, player);
    }

    public void broadcastChanges() {
        this.getTEData();
        super.broadcastChanges();
    }

    public ItemStack quickMoveStack(Player player, int index) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot != null && slot.hasItem()) {
            ItemStack slotStack = slot.getItem();
            itemstack = slotStack.copy();
            if (index == 10) {
                if (!this.moveItemStackTo(slotStack, 0, 9, true)) {
                    return ItemStack.EMPTY;
                }
                slot.onQuickCraft(slotStack, itemstack);
            } else if (index == 9 || index == 11) {
                if (!this.moveItemStackTo(slotStack, 0, 9, false)) {
                    return ItemStack.EMPTY;
                }
            } else if (index < 9) {
                Slot inputSlot = (Slot)this.slots.get(9);
                Slot fuelSlot = (Slot)this.slots.get(11);
                if (inputSlot.mayPlace(slotStack)) {
                    if (!this.moveItemStackTo(slotStack, 9, 10, false)) {
                        return ItemStack.EMPTY;
                    }
                } else if (fuelSlot.mayPlace(slotStack)) {
                    if (!this.moveItemStackTo(slotStack, 11, 12, false)) {
                        return ItemStack.EMPTY;
                    }
                } else {
                    return ItemStack.EMPTY;
                }
            }
            if (slotStack.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (slotStack.getCount() == itemstack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(player, slotStack);
        }
        return itemstack;
    }

    public void craft(int craft) {
        if (this.decomposerTE != null) {
            this.decomposerTE.setCraft(craft);
        }
    }

    public ContainerLevelAccess getContext() {
        return this.context;
    }
}

