/*
 * Decompiled with CFR 0.152.
 */
package com.razznature.decocraft.utils;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.razznature.decocraft.DecoException;
import com.razznature.decocraft.common.JsonContainer;
import com.razznature.decocraft.models.bbmodel.BBModel;
import com.razznature.decocraft.models.bbmodel.BBModelLoader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;

public class JsonParser {
    public static String[] parseFiles(String location) {
        block7: {
            String[] stringArray;
            GsonBuilder gsonBuilder = new GsonBuilder().setPrettyPrinting();
            Gson gson = gsonBuilder.create();
            InputStream stream = JsonParser.class.getClassLoader().getResourceAsStream(location);
            if (stream == null) break block7;
            InputStreamReader reader = new InputStreamReader(stream);
            try {
                stringArray = (String[])gson.fromJson((Reader)reader, String[].class);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        reader.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            reader.close();
            return stringArray;
        }
        throw new DecoException("Could not find or parse: " + location);
    }

    public static JsonContainer parseDecocraft(String location) {
        JsonContainer models = null;
        try {
            InputStream stream = JsonParser.class.getClassLoader().getResourceAsStream(location);
            if (stream != null) {
                models = new JsonContainer((InputStream)stream).entries;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new DecoException("Error! Problem reading " + location);
        }
        if (models == null) {
            throw new DecoException("Error! The number of models is null for: " + location);
        }
        return models;
    }

    public static BBModel parseModel(String location) {
        BBModel model = null;
        try {
            InputStream stream = JsonParser.class.getClassLoader().getResourceAsStream(location);
            if (stream != null) {
                model = new BBModelLoader().loadModel(stream);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new DecoException("Error finding the bbmodel: " + location);
        }
        if (model == null) {
            throw new DecoException("Error loading BBModel from: " + location);
        }
        return model;
    }
}

