/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.crafting.ingredient;

import com.blakebr0.mysticalagriculture.init.ModIngredientTypes;
import com.mojang.serialization.MapCodec;
import java.util.stream.Stream;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.crafting.ICustomIngredient;
import net.neoforged.neoforge.common.crafting.IngredientType;
import org.jetbrains.annotations.Nullable;

public class HoeIngredient
implements ICustomIngredient {
    public static final MapCodec<HoeIngredient> CODEC = MapCodec.unit(HoeIngredient::new);
    private ItemStack[] stacks;

    public boolean test(@Nullable ItemStack stack) {
        if (stack != null) {
            if (this.stacks == null) {
                this.initMatchingStacks();
            }
            for (ItemStack itemstack : this.stacks) {
                if (itemstack.getItem() != stack.getItem()) continue;
                return true;
            }
        }
        return false;
    }

    public Stream<ItemStack> getItems() {
        if (this.stacks == null) {
            this.initMatchingStacks();
        }
        return Stream.of(this.stacks);
    }

    public boolean isSimple() {
        return true;
    }

    public IngredientType<?> getType() {
        return (IngredientType)ModIngredientTypes.ALL_HOES.get();
    }

    private void initMatchingStacks() {
        this.stacks = (ItemStack[])BuiltInRegistries.ITEM.entrySet().stream().filter(i -> i.getValue() instanceof HoeItem).map(i -> new ItemStack((ItemLike)i.getValue())).toArray(ItemStack[]::new);
    }
}

