/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolscontrol.modules.various.blocks;

import java.util.function.Function;
import javax.annotation.Nonnull;
import mcjty.lib.api.container.DefaultContainerProvider;
import mcjty.lib.bindings.GuiValue;
import mcjty.lib.bindings.Value;
import mcjty.lib.tileentity.Cap;
import mcjty.lib.tileentity.CapType;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.typed.Type;
import mcjty.rftoolscontrol.modules.processor.blocks.ProcessorTileEntity;
import mcjty.rftoolscontrol.modules.various.VariousModule;
import mcjty.rftoolscontrol.modules.various.data.NodeData;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class NodeTileEntity
extends GenericTileEntity {
    @GuiValue
    public static final Value<NodeTileEntity, String> VALUE_CHANNEL = Value.create((String)"channel", (Type)Type.STRING, NodeTileEntity::getChannelName, NodeTileEntity::setChannelName);
    @GuiValue
    public static final Value<NodeTileEntity, String> VALUE_NODE = Value.create((String)"node", (Type)Type.STRING, NodeTileEntity::getNodeName, NodeTileEntity::setNodeName);
    private int prevIn = 0;
    private final int[] powerOut = new int[]{0, 0, 0, 0, 0, 0};
    @Cap(type=CapType.CONTAINER)
    private static final Function<NodeTileEntity, MenuProvider> SCREEN_CAP = tile -> new DefaultContainerProvider("Node").containerSupplier(DefaultContainerProvider.empty(VariousModule.NODE_CONTAINER, (GenericTileEntity)tile)).data(VariousModule.NODE_DATA, NodeData.STREAM_CODEC, NodeData.CODEC).setupSync((GenericTileEntity)tile);

    public NodeTileEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)VariousModule.NODE.be().get(), pos, state);
    }

    public String getNodeName() {
        NodeData data = (NodeData)this.getData(VariousModule.NODE_DATA.get());
        return data.node() == null ? "" : data.node();
    }

    public String getChannelName() {
        NodeData data = (NodeData)this.getData(VariousModule.NODE_DATA.get());
        return data.channel() == null ? "" : data.channel();
    }

    public void setChannelName(String channel) {
        NodeData data = (NodeData)this.getData(VariousModule.NODE_DATA.get());
        this.setData(VariousModule.NODE_DATA.get(), data.withChannel(channel));
    }

    public void setNodeName(String node) {
        NodeData data = (NodeData)this.getData(VariousModule.NODE_DATA.get());
        this.setData(VariousModule.NODE_DATA.get(), data.withNode(node));
    }

    public BlockPos getProcessor() {
        return ((NodeData)this.getData(VariousModule.NODE_DATA.get())).processor();
    }

    public void setProcessor(BlockPos processor) {
        NodeData data = (NodeData)this.getData(VariousModule.NODE_DATA.get());
        this.setData(VariousModule.NODE_DATA.get(), data.withProcessor(processor));
    }

    public void setPowerInput(int powered) {
        if (this.powerLevel != powered) {
            BlockEntity te;
            BlockPos processorPos = this.getProcessor();
            if (processorPos != null && this.getLevel() != null && (te = this.getLevel().getBlockEntity(processorPos)) instanceof ProcessorTileEntity) {
                ProcessorTileEntity processor = (ProcessorTileEntity)te;
                processor.redstoneNodeChange(this.prevIn, powered, this.getNodeName());
            }
            this.prevIn = powered;
        }
        super.setPowerInput(powered);
    }

    public int getPowerOut(Direction side) {
        return this.powerOut[side.ordinal()];
    }

    public void setPowerOut(Direction side, int powerOut) {
        this.powerOut[side.ordinal()] = powerOut;
        this.setChanged();
        this.getLevel().neighborChanged(this.worldPosition.relative(side), this.getBlockState().getBlock(), this.worldPosition);
    }

    public void loadAdditional(CompoundTag tagCompound, HolderLookup.Provider provider) {
        super.loadAdditional(tagCompound, provider);
        this.prevIn = tagCompound.getInt("prevIn");
        for (int i = 0; i < 6; ++i) {
            this.powerOut[i] = tagCompound.getByte("p" + i);
        }
    }

    public void saveAdditional(@Nonnull CompoundTag tagCompound, HolderLookup.Provider provider) {
        super.saveAdditional(tagCompound, provider);
        tagCompound.putInt("prevIn", this.prevIn);
        for (int i = 0; i < 6; ++i) {
            tagCompound.putByte("p" + i, (byte)this.powerOut[i]);
        }
    }

    protected void collectImplicitComponents(DataComponentMap.Builder builder) {
        super.collectImplicitComponents(builder);
        builder.set((DataComponentType)VariousModule.ITEM_NODE_DATA.get(), (Object)((NodeData)this.getData(VariousModule.NODE_DATA.get())));
    }

    protected void applyImplicitComponents(BlockEntity.DataComponentInput input) {
        super.applyImplicitComponents(input);
        NodeData data = (NodeData)input.get((DataComponentType)VariousModule.ITEM_NODE_DATA.get());
        if (data != null) {
            this.setData(VariousModule.NODE_DATA.get(), data);
        }
    }
}

