/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolscontrol.modules.various.items.interactionmodule;

import com.mojang.serialization.Codec;
import java.util.function.Function;
import javax.annotation.Nonnull;
import mcjty.lib.varia.BlockPosTools;
import mcjty.lib.varia.Logging;
import mcjty.lib.varia.ModuleTools;
import mcjty.lib.varia.Tools;
import mcjty.rftoolsbase.api.screens.IClientScreenModule;
import mcjty.rftoolsbase.api.screens.IModuleGuiBuilder;
import mcjty.rftoolsbase.api.screens.IScreenModule;
import mcjty.rftoolsbase.api.screens.TextAlign;
import mcjty.rftoolsbase.tools.GenericModuleItem;
import mcjty.rftoolscontrol.RFToolsControl;
import mcjty.rftoolscontrol.modules.processor.ProcessorModule;
import mcjty.rftoolscontrol.modules.various.VariousModule;
import mcjty.rftoolscontrol.modules.various.items.interactionmodule.InteractionClientScreenModule;
import mcjty.rftoolscontrol.modules.various.items.interactionmodule.InteractionScreenModule;
import mcjty.rftoolscontrol.setup.Config;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class InteractionModuleItem
extends GenericModuleItem {
    public InteractionModuleItem() {
        super(RFToolsControl.setup.defaultProperties().stacksTo(1).durability(1));
    }

    @Nullable
    public Codec<? extends IScreenModule<?, ?>> codec() {
        return InteractionScreenModule.CODEC;
    }

    @Nullable
    public StreamCodec<RegistryFriendlyByteBuf, ? extends IScreenModule<?, ?>> streamCodec() {
        return InteractionScreenModule.STREAM_CODEC;
    }

    @Nullable
    public DataComponentType<? extends IScreenModule<?, ?>> componentType() {
        return (DataComponentType)VariousModule.INTERACTION_MODULE_DATA.get();
    }

    public IScreenModule<?, ?> createServerScreenModule() {
        return InteractionScreenModule.DEFAULT;
    }

    public IClientScreenModule<?> createClientScreenModule() {
        return new InteractionClientScreenModule();
    }

    protected int getUses(ItemStack stack) {
        return (Integer)Config.INTERACTMODULE_RFPERTICK.get();
    }

    protected boolean hasGoldMessage(ItemStack stack) {
        return !ModuleTools.hasModuleTarget((ItemStack)stack);
    }

    protected String getInfoString(ItemStack stack) {
        return ModuleTools.getTargetString((ItemStack)stack);
    }

    public String getModuleName() {
        return "INT";
    }

    public void createGui(IModuleGuiBuilder guiBuilder) {
        guiBuilder.label("Label:").text((stack, s) -> InteractionModuleItem.data(stack, module -> module.withLine((String)s)), stack -> InteractionModuleItem.data(stack).line(), new String[]{"Label text"}).color((stack, c) -> InteractionModuleItem.data(stack, module -> module.withColor((int)c)), stack -> InteractionModuleItem.data(stack).color(), new String[]{"Label color"}).nl().label("Button:").text((stack, s) -> InteractionModuleItem.data(stack, module -> module.withButton((String)s)), stack -> InteractionModuleItem.data(stack).button(), new String[]{"Button text"}).color((stack, c) -> InteractionModuleItem.data(stack, module -> module.withButtonColor((int)c)), stack -> InteractionModuleItem.data(stack).buttonColor(), new String[]{"Button color"}).nl().label("Signal:").text((stack, s) -> InteractionModuleItem.data(stack, module -> module.withSignal((String)s)), stack -> InteractionModuleItem.data(stack).signal(), new String[]{"Signal name"}).nl().choices((stack, choice) -> InteractionModuleItem.data(stack, module -> module.withAlign(TextAlign.get((String)choice))), stack -> InteractionModuleItem.data(stack).align().getSerializedName(), "Label alignment", new String[]{"Left", "Center", "Right"}).nl();
    }

    @Nonnull
    public InteractionResult useOn(UseOnContext context) {
        Player player = context.getPlayer();
        InteractionHand hand = context.getHand();
        Level world = context.getLevel();
        BlockPos pos = context.getClickedPos();
        ItemStack stack = player.getItemInHand(hand);
        BlockState state = world.getBlockState(pos);
        Block block = state.getBlock();
        if (block == ProcessorModule.PROCESSOR.block().get()) {
            InteractionModuleItem.data(stack, module -> module.withTarget((ResourceKey<Level>)world.dimension(), pos));
            ModuleTools.setPositionInModule((ItemStack)stack, (ResourceKey)world.dimension(), (BlockPos)pos, (String)Tools.getReadableName((Level)world, (BlockPos)pos));
            if (world.isClientSide) {
                Logging.message((Player)player, (String)"Interaction module is set to block");
            }
        } else {
            InteractionModuleItem.data(stack, module -> module.withCoordinate(BlockPosTools.INVALID));
            ModuleTools.clearPositionInModule((ItemStack)stack);
            if (world.isClientSide) {
                Logging.message((Player)player, (String)"Interaction module is cleared");
            }
        }
        return InteractionResult.SUCCESS;
    }

    public static InteractionScreenModule data(ItemStack stack) {
        InteractionScreenModule data = (InteractionScreenModule)stack.get(VariousModule.INTERACTION_MODULE_DATA);
        if (data == null) {
            data = InteractionScreenModule.DEFAULT;
        }
        return data;
    }

    public static void data(ItemStack stack, Function<InteractionScreenModule, InteractionScreenModule> setter) {
        InteractionScreenModule data = InteractionModuleItem.data(stack);
        data = setter.apply(data);
        stack.set((DataComponentType)VariousModule.INTERACTION_MODULE_DATA.get(), (Object)data);
    }
}

