/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsstorage.storage;

import java.util.Objects;
import javax.annotation.Nonnull;
import mcjty.lib.varia.LevelTools;
import mcjty.rftoolsstorage.storage.IStorageListener;
import mcjty.rftoolsstorage.storage.StorageEntry;
import mcjty.rftoolsstorage.storage.StorageHolder;
import mcjty.rftoolsstorage.storage.StorageInfo;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.items.IItemHandlerModifiable;

public class GlobalStorageItemWrapper
implements IItemHandlerModifiable {
    @Nonnull
    private StorageInfo info;
    private StorageEntry storage;
    private NonNullList<ItemStack> emptyHandler = NonNullList.withSize((int)10, (Object)ItemStack.EMPTY);
    private final boolean remote;
    private IStorageListener listener;

    public GlobalStorageItemWrapper(@Nonnull StorageInfo info, boolean remote) {
        this.info = info;
        this.remote = remote;
    }

    public void setInfo(@Nonnull StorageInfo info) {
        if (Objects.equals(info, this.info)) {
            return;
        }
        this.info = info;
        if (info.size() != this.emptyHandler.size() && info.size() > 0) {
            this.emptyHandler = NonNullList.withSize((int)info.size(), (Object)ItemStack.EMPTY);
        }
        this.storage = null;
    }

    public void setListener(IStorageListener listener) {
        this.listener = listener;
    }

    private void createStorage() {
        if (this.storage == null && this.info.uuid() != null && !this.remote) {
            this.storage = StorageHolder.get((Level)LevelTools.getOverworld()).getOrCreateStorageEntry(this.info.uuid(), this.info.size(), this.info.createdBy());
        }
    }

    @Nonnull
    private NonNullList<ItemStack> getStacks() {
        this.createStorage();
        if (this.storage == null) {
            return this.emptyHandler;
        }
        return this.storage.getStacks();
    }

    public StorageEntry getStorage() {
        this.createStorage();
        return this.storage;
    }

    public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
        if (this.info.isEmpty()) {
            return;
        }
        NonNullList<ItemStack> stacks = this.getStacks();
        if (slot >= stacks.size()) {
            return;
        }
        stacks.set(slot, (Object)stack);
        this.onContentsChanged(slot);
    }

    private void onContentsChanged(int slot) {
        if (!this.remote) {
            if (this.storage != null) {
                this.storage.updateVersion();
                if (this.listener != null) {
                    this.listener.onContentsChanged(this.storage.getVersion(), slot);
                }
            }
            StorageHolder.get((Level)LevelTools.getOverworld()).save();
        }
    }

    public int getSlots() {
        return this.getStacks().size();
    }

    @Nonnull
    public ItemStack getStackInSlot(int slot) {
        NonNullList<ItemStack> stacks = this.getStacks();
        if (slot >= stacks.size()) {
            return ItemStack.EMPTY;
        }
        return (ItemStack)stacks.get(slot);
    }

    private int getStackLimit(int slot, @Nonnull ItemStack stack) {
        return Math.min(this.getSlotLimit(slot), stack.getMaxStackSize());
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        boolean reachedLimit;
        if (this.info.isEmpty()) {
            return stack;
        }
        if (stack.isEmpty()) {
            return ItemStack.EMPTY;
        }
        if (!this.isItemValid(slot, stack)) {
            return stack;
        }
        NonNullList<ItemStack> stacks = this.getStacks();
        if (slot >= stacks.size()) {
            return stack;
        }
        ItemStack existing = (ItemStack)stacks.get(slot);
        int limit = this.getStackLimit(slot, stack);
        if (!existing.isEmpty()) {
            if (!ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)existing)) {
                return stack;
            }
            limit -= existing.getCount();
        }
        if (limit <= 0) {
            return stack;
        }
        boolean bl = reachedLimit = stack.getCount() > limit;
        if (!simulate) {
            if (existing.isEmpty()) {
                stacks.set(slot, (Object)(reachedLimit ? stack.copyWithCount(limit) : stack));
            } else {
                existing.grow(reachedLimit ? limit : stack.getCount());
            }
            this.onContentsChanged(slot);
        }
        return reachedLimit ? stack.copyWithCount(stack.getCount() - limit) : ItemStack.EMPTY;
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (amount == 0 || this.info.isEmpty()) {
            return ItemStack.EMPTY;
        }
        NonNullList<ItemStack> stacks = this.getStacks();
        if (slot >= stacks.size()) {
            return ItemStack.EMPTY;
        }
        ItemStack existing = (ItemStack)stacks.get(slot);
        if (existing.isEmpty()) {
            return ItemStack.EMPTY;
        }
        int toExtract = Math.min(amount, existing.getMaxStackSize());
        if (existing.getCount() <= toExtract) {
            if (!simulate) {
                stacks.set(slot, (Object)ItemStack.EMPTY);
                this.onContentsChanged(slot);
            }
            return existing;
        }
        if (!simulate) {
            stacks.set(slot, (Object)existing.copyWithCount(existing.getCount() - toExtract));
            this.onContentsChanged(slot);
        }
        return existing.copyWithCount(toExtract);
    }

    public int getSlotLimit(int slot) {
        return 64;
    }

    public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
        if (this.info.isEmpty()) {
            return false;
        }
        return slot < this.info.size();
    }
}

