/*
 * Decompiled with CFR 0.152.
 */
package com.reazip.economycraft;

import com.mojang.brigadier.CommandDispatcher;
import com.reazip.economycraft.EconomyCommands;
import com.reazip.economycraft.EconomyConfig;
import com.reazip.economycraft.EconomyManager;
import com.reazip.economycraft.util.ChatCompat;
import dev.architectury.event.events.common.CommandRegistrationEvent;
import dev.architectury.event.events.common.LifecycleEvent;
import dev.architectury.event.events.common.PlayerEvent;
import java.text.NumberFormat;
import java.util.Locale;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;

public final class EconomyCraft {
    public static final String MOD_ID = "economycraft";
    private static EconomyManager manager;
    private static MinecraftServer lastServer;
    private static final NumberFormat FORMAT;

    public static void registerEvents() {
        CommandRegistrationEvent.EVENT.register((dispatcher, registry, selection) -> EconomyCommands.register((CommandDispatcher<CommandSourceStack>)dispatcher));
        LifecycleEvent.SERVER_STARTED.register(server -> {
            EconomyConfig.load(null);
            EconomyCraft.getManager(server);
        });
        LifecycleEvent.SERVER_STOPPING.register(server -> {
            if (manager != null && lastServer == server) {
                manager.save();
            }
        });
        PlayerEvent.PLAYER_JOIN.register(player -> EconomyCraft.onPlayerJoin(player));
    }

    private static void onPlayerJoin(ServerPlayer player) {
        EconomyManager eco = EconomyCraft.getManager(player.getServer());
        eco.getBalance(player.getUUID(), true);
        if (eco.getOrders().hasDeliveries(player.getUUID()) || eco.getShop().hasDeliveries(player.getUUID())) {
            ClickEvent ev = ChatCompat.runCommandEvent("/eco orders claim");
            if (ev != null) {
                MutableComponent msg = Component.literal((String)"You have unclaimed items: ").withStyle(ChatFormatting.YELLOW).append((Component)Component.literal((String)"[Claim]").withStyle(s -> s.withUnderlined(Boolean.valueOf(true)).withColor(ChatFormatting.GREEN).withClickEvent(ev)));
                player.sendSystemMessage((Component)msg);
            } else {
                ChatCompat.sendRunCommandTellraw(player, "You have unclaimed items: ", "[Claim]", "/eco orders claim");
            }
        }
    }

    public static EconomyManager getManager(MinecraftServer server) {
        if (manager == null || lastServer != server) {
            manager = new EconomyManager(server);
            lastServer = server;
        }
        return manager;
    }

    public static String formatMoney(long amount) {
        return "$" + FORMAT.format(amount);
    }

    static {
        FORMAT = NumberFormat.getInstance(Locale.GERMANY);
    }
}

