/*
 * Decompiled with CFR 0.152.
 */
package com.reazip.economycraft.orders;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.reazip.economycraft.orders.OrderRequest;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class OrderManager {
    private static final Gson GSON = new Gson();
    private final MinecraftServer server;
    private final Path file;
    private final Map<Integer, OrderRequest> requests = new HashMap<Integer, OrderRequest>();
    private final Map<UUID, List<ItemStack>> deliveries = new HashMap<UUID, List<ItemStack>>();
    private int nextId = 1;
    private final List<Runnable> listeners = new ArrayList<Runnable>();

    public OrderManager(MinecraftServer server) {
        this.server = server;
        Path dir = server.getFile("config/economycraft");
        Path dataDir = dir.resolve("data");
        try {
            Files.createDirectories(dataDir, new FileAttribute[0]);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.file = dataDir.resolve("orders.json");
        this.load();
    }

    public Collection<OrderRequest> getRequests() {
        return this.requests.values();
    }

    public OrderRequest getRequest(int id) {
        return this.requests.get(id);
    }

    public void addRequest(OrderRequest r) {
        r.id = this.nextId++;
        this.requests.put(r.id, r);
        this.notifyListeners();
        this.save();
    }

    public OrderRequest removeRequest(int id) {
        OrderRequest r = this.requests.remove(id);
        if (r != null) {
            this.notifyListeners();
            this.save();
        }
        return r;
    }

    public void addDelivery(UUID player, ItemStack stack) {
        this.deliveries.computeIfAbsent(player, k -> new ArrayList()).add(stack);
        this.save();
    }

    public List<ItemStack> getDeliveries(UUID player) {
        return this.deliveries.computeIfAbsent(player, k -> new ArrayList());
    }

    public void removeDelivery(UUID player, ItemStack stack) {
        List<ItemStack> list = this.deliveries.get(player);
        if (list != null) {
            list.remove(stack);
            if (list.isEmpty()) {
                this.deliveries.remove(player);
            }
            this.save();
        }
    }

    public List<ItemStack> claimDeliveries(UUID player) {
        List<ItemStack> list = this.deliveries.remove(player);
        if (list != null) {
            this.save();
        }
        return list;
    }

    public boolean hasDeliveries(UUID player) {
        List<ItemStack> list = this.deliveries.get(player);
        return list != null && !list.isEmpty();
    }

    public void load() {
        if (Files.exists(this.file, new LinkOption[0])) {
            try {
                String json = Files.readString(this.file);
                JsonObject root = (JsonObject)GSON.fromJson(json, JsonObject.class);
                this.nextId = root.get("nextId").getAsInt();
                for (JsonElement el : root.getAsJsonArray("requests")) {
                    OrderRequest r = OrderRequest.load(el.getAsJsonObject(), (HolderLookup.Provider)this.server.registryAccess());
                    this.requests.put(r.id, r);
                }
                JsonObject dObj = root.getAsJsonObject("deliveries");
                for (String key : dObj.keySet()) {
                    UUID id = UUID.fromString(key);
                    ArrayList<ItemStack> list = new ArrayList<ItemStack>();
                    for (JsonElement sEl : dObj.getAsJsonArray(key)) {
                        JsonObject o = sEl.getAsJsonObject();
                        ItemStack stack = ItemStack.EMPTY;
                        if (o.has("stack")) {
                            stack = ItemStack.CODEC.parse((DynamicOps)RegistryOps.create((DynamicOps)JsonOps.INSTANCE, (HolderLookup.Provider)this.server.registryAccess()), (Object)o.get("stack")).result().orElse(ItemStack.EMPTY);
                        } else {
                            Optional opt;
                            String itemId = o.get("item").getAsString();
                            int count = o.get("count").getAsInt();
                            ResourceLocation rl = ResourceLocation.tryParse((String)itemId);
                            if (rl != null && (opt = BuiltInRegistries.ITEM.getOptional(rl)).isPresent()) {
                                Item item = (Item)opt.get();
                                stack = new ItemStack((ItemLike)item, count);
                            }
                        }
                        if (stack.isEmpty()) continue;
                        list.add(stack);
                    }
                    this.deliveries.put(id, list);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void save() {
        JsonObject root = new JsonObject();
        root.addProperty("nextId", (Number)this.nextId);
        JsonArray reqArr = new JsonArray();
        for (OrderRequest r : this.requests.values()) {
            reqArr.add((JsonElement)r.save((HolderLookup.Provider)this.server.registryAccess()));
        }
        root.add("requests", (JsonElement)reqArr);
        JsonObject dObj = new JsonObject();
        for (Map.Entry<UUID, List<ItemStack>> e : this.deliveries.entrySet()) {
            JsonArray arr = new JsonArray();
            for (ItemStack s : e.getValue()) {
                JsonObject o = new JsonObject();
                o.addProperty("item", BuiltInRegistries.ITEM.getKey((Object)s.getItem()).toString());
                o.addProperty("count", (Number)s.getCount());
                JsonElement stackEl = (JsonElement)ItemStack.CODEC.encodeStart((DynamicOps)RegistryOps.create((DynamicOps)JsonOps.INSTANCE, (HolderLookup.Provider)this.server.registryAccess()), (Object)s).result().orElse(new JsonObject());
                o.add("stack", stackEl);
                arr.add((JsonElement)o);
            }
            dObj.add(e.getKey().toString(), (JsonElement)arr);
        }
        root.add("deliveries", (JsonElement)dObj);
        try {
            Files.writeString(this.file, (CharSequence)GSON.toJson((JsonElement)root), new OpenOption[0]);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void addListener(Runnable run) {
        this.listeners.add(run);
    }

    public void removeListener(Runnable run) {
        this.listeners.remove(run);
    }

    private void notifyListeners() {
        for (Runnable r : new ArrayList<Runnable>(this.listeners)) {
            r.run();
        }
    }
}

