/*
 * Decompiled with CFR 0.152.
 */
package com.reazip.economycraft.orders;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class OrderRequest {
    public int id;
    public UUID requester;
    public ItemStack item;
    public int amount;
    public long price;

    public JsonObject save(HolderLookup.Provider provider) {
        JsonObject obj = new JsonObject();
        obj.addProperty("id", (Number)this.id);
        if (this.requester != null) {
            obj.addProperty("requester", this.requester.toString());
        }
        obj.addProperty("price", (Number)this.price);
        obj.addProperty("item", BuiltInRegistries.ITEM.getKey((Object)this.item.getItem()).toString());
        obj.addProperty("amount", (Number)this.amount);
        JsonElement stackEl = (JsonElement)ItemStack.CODEC.encodeStart((DynamicOps)RegistryOps.create((DynamicOps)JsonOps.INSTANCE, (HolderLookup.Provider)provider), (Object)this.item).result().orElse(new JsonObject());
        obj.add("stack", stackEl);
        return obj;
    }

    public static OrderRequest load(JsonObject obj, HolderLookup.Provider provider) {
        String itemId;
        ResourceLocation rl;
        OrderRequest r = new OrderRequest();
        r.id = obj.get("id").getAsInt();
        if (obj.has("requester")) {
            r.requester = UUID.fromString(obj.get("requester").getAsString());
        }
        r.price = obj.get("price").getAsLong();
        r.amount = obj.get("amount").getAsInt();
        if (obj.has("stack")) {
            r.item = ItemStack.CODEC.parse((DynamicOps)RegistryOps.create((DynamicOps)JsonOps.INSTANCE, (HolderLookup.Provider)provider), (Object)obj.get("stack")).result().orElse(ItemStack.EMPTY);
        }
        if ((r.item == null || r.item.isEmpty()) && (rl = ResourceLocation.tryParse((String)(itemId = obj.get("item").getAsString()))) != null) {
            Optional opt = BuiltInRegistries.ITEM.getOptional(rl);
            opt.ifPresent(item -> {
                r.item = new ItemStack((ItemLike)item);
            });
        }
        return r;
    }
}

