/*
 * Decompiled with CFR 0.152.
 */
package com.reazip.economycraft.shop;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class ShopListing {
    public int id;
    public UUID seller;
    public ItemStack item;
    public long price;

    public JsonObject save(HolderLookup.Provider provider) {
        JsonObject obj = new JsonObject();
        obj.addProperty("id", (Number)this.id);
        if (this.seller != null) {
            obj.addProperty("seller", this.seller.toString());
        }
        obj.addProperty("price", (Number)this.price);
        obj.addProperty("item", BuiltInRegistries.ITEM.getKey((Object)this.item.getItem()).toString());
        obj.addProperty("count", (Number)this.item.getCount());
        JsonElement stackEl = (JsonElement)ItemStack.CODEC.encodeStart((DynamicOps)RegistryOps.create((DynamicOps)JsonOps.INSTANCE, (HolderLookup.Provider)provider), (Object)this.item).result().orElse(new JsonObject());
        obj.add("stack", stackEl);
        return obj;
    }

    public static ShopListing load(JsonObject obj, HolderLookup.Provider provider) {
        ShopListing l = new ShopListing();
        l.id = obj.get("id").getAsInt();
        if (obj.has("seller")) {
            l.seller = UUID.fromString(obj.get("seller").getAsString());
        }
        l.price = obj.get("price").getAsLong();
        if (obj.has("stack")) {
            l.item = ItemStack.CODEC.parse((DynamicOps)RegistryOps.create((DynamicOps)JsonOps.INSTANCE, (HolderLookup.Provider)provider), (Object)obj.get("stack")).result().orElse(ItemStack.EMPTY);
        }
        if (l.item == null || l.item.isEmpty()) {
            String itemId = obj.get("item").getAsString();
            int count = obj.get("count").getAsInt();
            ResourceLocation rl = ResourceLocation.tryParse((String)itemId);
            if (rl != null) {
                Optional opt = BuiltInRegistries.ITEM.getOptional(rl);
                opt.ifPresent(item -> {
                    l.item = new ItemStack((ItemLike)item, count);
                });
            }
        }
        return l;
    }
}

