/*
 * Decompiled with CFR 0.152.
 */
package com.reazip.economycraft.shop;

import com.reazip.economycraft.EconomyConfig;
import com.reazip.economycraft.EconomyCraft;
import com.reazip.economycraft.EconomyManager;
import com.reazip.economycraft.shop.ShopListing;
import com.reazip.economycraft.shop.ShopManager;
import com.reazip.economycraft.util.ChatCompat;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.ItemLore;
import net.minecraft.world.level.ItemLike;

public final class ShopUi {
    private ShopUi() {
    }

    public static void open(final ServerPlayer player, final ShopManager shop) {
        player.openMenu(new MenuProvider(){

            public Component getDisplayName() {
                return Component.literal((String)"Shop");
            }

            public AbstractContainerMenu createMenu(int id, Inventory inv, Player p) {
                return new ShopMenu(id, inv, shop, player);
            }
        });
    }

    static void openConfirm(final ServerPlayer player, final ShopManager shop, final ShopListing listing) {
        player.openMenu(new MenuProvider(){

            public Component getDisplayName() {
                return Component.literal((String)"Confirm");
            }

            public AbstractContainerMenu createMenu(int id, Inventory inv, Player p) {
                return new ConfirmMenu(id, inv, shop, listing, player);
            }
        });
    }

    private static void openRemove(final ServerPlayer player, final ShopManager shop, final ShopListing listing) {
        player.openMenu(new MenuProvider(){

            public Component getDisplayName() {
                return Component.literal((String)"Remove");
            }

            public AbstractContainerMenu createMenu(int id, Inventory inv, Player p) {
                return new RemoveMenu(id, inv, shop, listing, player);
            }
        });
    }

    private static class RemoveMenu
    extends AbstractContainerMenu {
        private final ShopManager shop;
        private final ShopListing listing;
        private final ServerPlayer viewer;
        private final SimpleContainer container = new SimpleContainer(9);

        RemoveMenu(int id, Inventory inv, ShopManager shop, ShopListing listing, ServerPlayer viewer) {
            super(MenuType.GENERIC_9x1, id);
            this.shop = shop;
            this.listing = listing;
            this.viewer = viewer;
            ItemStack confirm = new ItemStack((ItemLike)Items.LIME_STAINED_GLASS_PANE);
            confirm.set(DataComponents.CUSTOM_NAME, (Object)Component.literal((String)"Confirm"));
            this.container.setItem(2, confirm);
            ItemStack item = listing.item.copy();
            long tax = Math.round((double)listing.price * EconomyConfig.get().taxRate);
            item.set(DataComponents.LORE, (Object)new ItemLore(List.of(Component.literal((String)("Price: " + EconomyCraft.formatMoney(listing.price) + " (+" + EconomyCraft.formatMoney(tax) + " tax)")), Component.literal((String)"Seller: you"), Component.literal((String)"This will remove the listing"))));
            this.container.setItem(4, item);
            ItemStack cancel = new ItemStack((ItemLike)Items.RED_STAINED_GLASS_PANE);
            cancel.set(DataComponents.CUSTOM_NAME, (Object)Component.literal((String)"Cancel"));
            this.container.setItem(6, cancel);
            for (int i = 0; i < 9; ++i) {
                this.addSlot(new Slot(this, (Container)this.container, i, 8 + i * 18, 20){

                    public boolean mayPickup(Player p) {
                        return false;
                    }
                });
            }
            int y = 40;
            for (int r = 0; r < 3; ++r) {
                for (int c = 0; c < 9; ++c) {
                    this.addSlot(new Slot((Container)inv, c + r * 9 + 9, 8 + c * 18, y + r * 18));
                }
            }
            for (int c = 0; c < 9; ++c) {
                this.addSlot(new Slot((Container)inv, c, 8 + c * 18, y + 58));
            }
        }

        public void clicked(int slot, int dragType, ClickType type, Player player) {
            if (type == ClickType.PICKUP) {
                if (slot == 2) {
                    ShopListing removed = this.shop.removeListing(this.listing.id);
                    if (removed != null) {
                        ItemStack stack = removed.item.copy();
                        if (!player.getInventory().add(stack)) {
                            this.shop.addDelivery(player.getUUID(), stack);
                            ClickEvent ev = ChatCompat.runCommandEvent("/eco orders claim");
                            if (ev != null) {
                                MutableComponent msg = Component.literal((String)"Item stored: ").withStyle(ChatFormatting.YELLOW).append((Component)Component.literal((String)"[Claim]").withStyle(s -> s.withUnderlined(Boolean.valueOf(true)).withColor(ChatFormatting.GREEN).withClickEvent(ev)));
                                ((ServerPlayer)player).sendSystemMessage((Component)msg);
                            } else {
                                ChatCompat.sendRunCommandTellraw((ServerPlayer)player, "Item stored: ", "[Claim]", "/eco orders claim");
                            }
                        } else {
                            this.viewer.sendSystemMessage((Component)Component.literal((String)"Listing removed"));
                        }
                    } else {
                        this.viewer.sendSystemMessage((Component)Component.literal((String)"Listing no longer available"));
                    }
                    player.closeContainer();
                    ShopUi.open((ServerPlayer)player, this.shop);
                    return;
                }
                if (slot == 6) {
                    player.closeContainer();
                    ShopUi.open((ServerPlayer)player, this.shop);
                    return;
                }
            }
            super.clicked(slot, dragType, type, player);
        }

        public boolean stillValid(Player player) {
            return true;
        }

        public ItemStack quickMoveStack(Player player, int idx) {
            return ItemStack.EMPTY;
        }
    }

    private static class ConfirmMenu
    extends AbstractContainerMenu {
        private final ShopManager shop;
        private final ShopListing listing;
        private final ServerPlayer viewer;
        private final SimpleContainer container = new SimpleContainer(9);

        ConfirmMenu(int id, Inventory inv, ShopManager shop, ShopListing listing, ServerPlayer viewer) {
            super(MenuType.GENERIC_9x1, id);
            this.shop = shop;
            this.listing = listing;
            this.viewer = viewer;
            ItemStack confirm = new ItemStack((ItemLike)Items.LIME_STAINED_GLASS_PANE);
            confirm.set(DataComponents.CUSTOM_NAME, (Object)Component.literal((String)"Confirm"));
            this.container.setItem(2, confirm);
            ItemStack item = listing.item.copy();
            String sellerName = viewer.getServer().getProfileCache().get(listing.seller).map(p -> p.getName()).orElse(listing.seller.toString());
            long tax = Math.round((double)listing.price * EconomyConfig.get().taxRate);
            item.set(DataComponents.LORE, (Object)new ItemLore(List.of(Component.literal((String)("Price: " + EconomyCraft.formatMoney(listing.price) + " (+" + EconomyCraft.formatMoney(tax) + " tax)")), Component.literal((String)("Seller: " + sellerName)))));
            this.container.setItem(4, item);
            ItemStack cancel = new ItemStack((ItemLike)Items.RED_STAINED_GLASS_PANE);
            cancel.set(DataComponents.CUSTOM_NAME, (Object)Component.literal((String)"Cancel"));
            this.container.setItem(6, cancel);
            for (int i = 0; i < 9; ++i) {
                this.addSlot(new Slot(this, (Container)this.container, i, 8 + i * 18, 20){

                    public boolean mayPickup(Player player) {
                        return false;
                    }
                });
            }
            int y = 40;
            for (int r = 0; r < 3; ++r) {
                for (int c = 0; c < 9; ++c) {
                    this.addSlot(new Slot((Container)inv, c + r * 9 + 9, 8 + c * 18, y + r * 18));
                }
            }
            for (int c = 0; c < 9; ++c) {
                this.addSlot(new Slot((Container)inv, c, 8 + c * 18, y + 58));
            }
        }

        public void clicked(int slot, int dragType, ClickType type, Player player) {
            if (type == ClickType.PICKUP) {
                if (slot == 2) {
                    ShopListing current = this.shop.getListing(this.listing.id);
                    if (current == null) {
                        ((ServerPlayer)player).sendSystemMessage((Component)Component.literal((String)"Listing no longer available"));
                    } else {
                        EconomyManager eco = EconomyCraft.getManager(((ServerPlayer)player).getServer());
                        long cost = current.price;
                        long tax = Math.round((double)cost * EconomyConfig.get().taxRate);
                        long total = cost + tax;
                        long bal = eco.getBalance(player.getUUID(), true);
                        if (bal < total) {
                            ((ServerPlayer)player).sendSystemMessage((Component)Component.literal((String)"Not enough balance").withStyle(ChatFormatting.RED));
                        } else {
                            eco.removeMoney(player.getUUID(), total);
                            eco.addMoney(current.seller, cost);
                            this.shop.removeListing(current.id);
                            ItemStack stack = current.item.copy();
                            int count = stack.getCount();
                            Component name = stack.getHoverName();
                            if (!player.getInventory().add(stack)) {
                                this.shop.addDelivery(player.getUUID(), stack);
                                ClickEvent ev = ChatCompat.runCommandEvent("/eco orders claim");
                                if (ev != null) {
                                    MutableComponent msg = Component.literal((String)"Item stored: ").withStyle(ChatFormatting.YELLOW).append((Component)Component.literal((String)"[Claim]").withStyle(s -> s.withUnderlined(Boolean.valueOf(true)).withColor(ChatFormatting.GREEN).withClickEvent(ev)));
                                    ((ServerPlayer)player).sendSystemMessage((Component)msg);
                                } else {
                                    ChatCompat.sendRunCommandTellraw((ServerPlayer)player, "Item stored: ", "[Claim]", "/eco orders claim");
                                }
                            } else {
                                ((ServerPlayer)player).sendSystemMessage((Component)Component.literal((String)("Purchased " + count + "x " + name.getString() + " for " + EconomyCraft.formatMoney(total))));
                            }
                        }
                    }
                    player.closeContainer();
                    ShopUi.open((ServerPlayer)player, this.shop);
                    return;
                }
                if (slot == 6) {
                    player.closeContainer();
                    ShopUi.open((ServerPlayer)player, this.shop);
                    return;
                }
            }
            super.clicked(slot, dragType, type, player);
        }

        public boolean stillValid(Player player) {
            return true;
        }

        public ItemStack quickMoveStack(Player player, int index) {
            return ItemStack.EMPTY;
        }
    }

    private static class ShopMenu
    extends AbstractContainerMenu {
        private final ShopManager shop;
        private final ServerPlayer viewer;
        private List<ShopListing> listings = new ArrayList<ShopListing>();
        private final SimpleContainer container = new SimpleContainer(54);
        private int page;
        private final Runnable listener = this::updatePage;

        ShopMenu(int id, Inventory inv, ShopManager shop, ServerPlayer viewer) {
            super(MenuType.GENERIC_9x6, id);
            int c;
            int r;
            this.shop = shop;
            this.viewer = viewer;
            this.updatePage();
            shop.addListener(this.listener);
            for (int i = 0; i < 54; ++i) {
                r = i / 9;
                c = i % 9;
                this.addSlot(new Slot(this, (Container)this.container, i, 8 + c * 18, 18 + r * 18){

                    public boolean mayPickup(Player player) {
                        return false;
                    }

                    public boolean mayPlace(ItemStack stack) {
                        return false;
                    }
                });
            }
            int y = 140;
            for (r = 0; r < 3; ++r) {
                for (c = 0; c < 9; ++c) {
                    this.addSlot(new Slot((Container)inv, c + r * 9 + 9, 8 + c * 18, y + r * 18));
                }
            }
            for (int c2 = 0; c2 < 9; ++c2) {
                this.addSlot(new Slot((Container)inv, c2, 8 + c2 * 18, y + 58));
            }
        }

        private void updatePage() {
            int idx;
            this.listings = new ArrayList<ShopListing>(this.shop.getListings());
            this.container.clearContent();
            int start = this.page * 45;
            int totalPages = (int)Math.ceil((double)this.listings.size() / 45.0);
            for (int i = 0; i < 45 && (idx = start + i) < this.listings.size(); ++i) {
                ShopListing l = this.listings.get(idx);
                ItemStack display = l.item.copy();
                String sellerName = this.viewer.getServer().getProfileCache().get(l.seller).map(p -> p.getName()).orElse(l.seller.toString());
                long tax = Math.round((double)l.price * EconomyConfig.get().taxRate);
                display.set(DataComponents.LORE, (Object)new ItemLore(List.of(Component.literal((String)("Price: " + EconomyCraft.formatMoney(l.price) + " (+" + EconomyCraft.formatMoney(tax) + " tax)")), Component.literal((String)("Seller: " + sellerName)))));
                this.container.setItem(i, display);
            }
            if (this.page > 0) {
                ItemStack prev = new ItemStack((ItemLike)Items.ARROW);
                prev.set(DataComponents.CUSTOM_NAME, (Object)Component.literal((String)"Previous page"));
                this.container.setItem(45, prev);
            }
            if (start + 45 < this.listings.size()) {
                ItemStack next = new ItemStack((ItemLike)Items.ARROW);
                next.set(DataComponents.CUSTOM_NAME, (Object)Component.literal((String)"Next page"));
                this.container.setItem(53, next);
            }
            ItemStack paper = new ItemStack((ItemLike)Items.PAPER);
            paper.set(DataComponents.CUSTOM_NAME, (Object)Component.literal((String)("Page " + (this.page + 1) + "/" + Math.max(1, totalPages))));
            this.container.setItem(49, paper);
        }

        public void clicked(int slot, int dragType, ClickType type, Player player) {
            if (type == ClickType.PICKUP) {
                int index;
                if (slot < 45 && (index = this.page * 45 + slot) < this.listings.size()) {
                    ShopListing listing = this.listings.get(index);
                    if (listing.seller.equals(player.getUUID())) {
                        ShopUi.openRemove((ServerPlayer)player, this.shop, listing);
                    } else {
                        ShopUi.openConfirm((ServerPlayer)player, this.shop, listing);
                    }
                    return;
                }
                if (slot == 45 && this.page > 0) {
                    --this.page;
                    this.updatePage();
                    return;
                }
                if (slot == 53 && (this.page + 1) * 45 < this.listings.size()) {
                    ++this.page;
                    this.updatePage();
                    return;
                }
            }
            super.clicked(slot, dragType, type, player);
        }

        public boolean stillValid(Player player) {
            return true;
        }

        public void removed(Player player) {
            super.removed(player);
            this.shop.removeListener(this.listener);
        }

        public ItemStack quickMoveStack(Player player, int index) {
            return ItemStack.EMPTY;
        }
    }
}

