/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.data.geometry;

import it.zerono.mods.zerocore.lib.data.geometry.Vector3d;
import java.util.Objects;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.phys.AABB;
import org.joml.Vector3f;

public class Cuboid {
    public static final Cuboid EMPTY = new Cuboid();
    public static final Cuboid FULL = new Cuboid(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
    public final Vector3d Min;
    public final Vector3d Max;

    public Cuboid(Vector3d min, Vector3d max) {
        this.Min = min;
        this.Max = max;
    }

    public Cuboid(double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        this(new Vector3d(minX, minY, minZ), new Vector3d(maxX, maxY, maxZ));
    }

    public Cuboid(Cuboid other) {
        this(new Vector3d(other.Min), new Vector3d(other.Max));
    }

    public Cuboid(Vec3i min, Vec3i max) {
        this(Vector3d.from(min), Vector3d.from(max));
    }

    public Cuboid(AABB boundingBox) {
        this(new Vector3d(boundingBox.minX, boundingBox.minY, boundingBox.minZ), new Vector3d(boundingBox.maxX, boundingBox.maxY, boundingBox.maxZ));
    }

    public static Cuboid syncDataFrom(CompoundTag data) {
        if (data.contains("min") && data.contains("max")) {
            return new Cuboid(Vector3d.syncDataFrom(data.getCompound("min")), Vector3d.syncDataFrom(data.getCompound("max")));
        }
        return EMPTY;
    }

    public CompoundTag syncDataTo(CompoundTag data) {
        data.put("min", (Tag)this.Min.syncDataTo(new CompoundTag()));
        data.put("max", (Tag)this.Max.syncDataTo(new CompoundTag()));
        return data;
    }

    public AABB toBoundingBox() {
        return new AABB(this.Min.X, this.Min.Y, this.Min.Z, this.Max.X, this.Max.Y, this.Max.Z);
    }

    public Cuboid add(double offsetX, double offsetY, double offsetZ) {
        return new Cuboid(this.Min.add(offsetX, offsetY, offsetZ), this.Max.add(offsetX, offsetY, offsetZ));
    }

    public Cuboid add(double offset) {
        return this.add(offset, offset, offset);
    }

    public Cuboid add(Vector3d data) {
        return this.add(data.X, data.Y, data.Z);
    }

    public Cuboid add(Vec3i data) {
        return this.add(data.getX(), data.getY(), data.getZ());
    }

    public Cuboid subtract(double offsetX, double offsetY, double offsetZ) {
        return new Cuboid(this.Min.subtract(offsetX, offsetY, offsetZ), this.Max.subtract(offsetX, offsetY, offsetZ));
    }

    public Cuboid subtract(double offset) {
        return this.subtract(offset, offset, offset);
    }

    public Cuboid subtract(Vector3d data) {
        return this.subtract(data.X, data.Y, data.Z);
    }

    public Cuboid subtract(Vec3i data) {
        return this.subtract(data.getX(), data.getY(), data.getZ());
    }

    public Cuboid expand(double deltaX, double deltaY, double deltaZ) {
        return new Cuboid(this.Min.subtract(deltaX, deltaY, deltaZ), this.Max.add(deltaX, deltaY, deltaZ));
    }

    public Cuboid expand(double delta) {
        return this.expand(delta, delta, delta);
    }

    public Cuboid expand(Vector3d delta) {
        return this.expand(delta.X, delta.Y, delta.Z);
    }

    public Cuboid expand(Direction side, int amount) {
        switch (side.getAxisDirection()) {
            case NEGATIVE: {
                return new Cuboid(this.Min.add(Vector3d.from(side.getNormal()).multiply(amount)), this.Max);
            }
            case POSITIVE: {
                return new Cuboid(this.Min, this.Max.add(Vector3d.from(side.getNormal()).multiply(amount)));
            }
        }
        return this;
    }

    public boolean contains(double x, double y, double z) {
        return this.Min.X - 1.0E-5 <= x && this.Min.Y - 1.0E-5 <= y && this.Min.Z - 1.0E-5 <= z && this.Max.X + 1.0E-5 >= x && this.Max.Y + 1.0E-5 >= y && this.Max.Z + 1.0E-5 >= z;
    }

    public boolean contains(Vector3d data) {
        return this.contains(data.X, data.Y, data.Z);
    }

    public boolean intersects(Cuboid other) {
        return this.Max.X - 1.0E-5 > other.Min.X && this.Max.Y - 1.0E-5 > other.Min.Y && this.Max.Z - 1.0E-5 > other.Min.Z && other.Max.X - 1.0E-5 > this.Min.X && other.Max.Y - 1.0E-5 > this.Min.Y && other.Max.Z - 1.0E-5 > this.Min.Z;
    }

    public double volume() {
        return (this.Max.X - this.Min.X + 1.0) * (this.Max.Y - this.Min.Y + 1.0) * (this.Max.Z - this.Min.Z + 1.0);
    }

    public Vector3d center() {
        return new Vector3d(this.Min).add(this.Max).multiply(0.5);
    }

    public Face getFace(Direction facing) {
        return new Face(this, facing);
    }

    public double getWidth() {
        return this.Max.X - this.Min.X;
    }

    public double getHeight() {
        return this.Max.Y - this.Min.Y;
    }

    public double getDepth() {
        return this.Max.Z - this.Min.Z;
    }

    public boolean equals(Object other) {
        if (other instanceof Cuboid) {
            Cuboid c = (Cuboid)other;
            return this.Min.equals(c.Min) && this.Max.equals(c.Max);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.Min, this.Max);
    }

    public String toString() {
        return String.format("Cuboid (%f, %f, %f), (%f, %f, %f)", this.Min.X, this.Min.Y, this.Min.Z, this.Max.X, this.Max.Y, this.Max.Z);
    }

    private Cuboid() {
        this.Min = this.Max = Vector3d.ZERO;
    }

    public static class Face {
        public final Vector3d A;
        public final Vector3d B;
        public final Vector3d C;
        public final Vector3d D;
        public final Direction FACING;

        private Face(Cuboid cuboid, Direction facing) {
            this.FACING = facing;
            switch (facing) {
                default: {
                    this.A = new Vector3d(cuboid.Min.X, cuboid.Max.Y, cuboid.Min.Z);
                    this.B = new Vector3d(cuboid.Min.X, cuboid.Max.Y, cuboid.Max.Z);
                    this.C = new Vector3d(cuboid.Max.X, cuboid.Max.Y, cuboid.Max.Z);
                    this.D = new Vector3d(cuboid.Max.X, cuboid.Max.Y, cuboid.Min.Z);
                    break;
                }
                case DOWN: {
                    this.A = new Vector3d(cuboid.Min.X, cuboid.Min.Y, cuboid.Min.Z);
                    this.B = new Vector3d(cuboid.Max.X, cuboid.Min.Y, cuboid.Min.Z);
                    this.C = new Vector3d(cuboid.Max.X, cuboid.Min.Y, cuboid.Max.Z);
                    this.D = new Vector3d(cuboid.Min.X, cuboid.Min.Y, cuboid.Max.Z);
                    break;
                }
                case WEST: {
                    this.A = new Vector3d(cuboid.Min.X, cuboid.Max.Y, cuboid.Min.Z);
                    this.B = new Vector3d(cuboid.Min.X, cuboid.Min.Y, cuboid.Min.Z);
                    this.C = new Vector3d(cuboid.Min.X, cuboid.Min.Y, cuboid.Max.Z);
                    this.D = new Vector3d(cuboid.Min.X, cuboid.Max.Y, cuboid.Max.Z);
                    break;
                }
                case EAST: {
                    this.A = new Vector3d(cuboid.Max.X, cuboid.Max.Y, cuboid.Max.Z);
                    this.B = new Vector3d(cuboid.Max.X, cuboid.Min.Y, cuboid.Max.Z);
                    this.C = new Vector3d(cuboid.Max.X, cuboid.Min.Y, cuboid.Min.Z);
                    this.D = new Vector3d(cuboid.Max.X, cuboid.Max.Y, cuboid.Min.Z);
                    break;
                }
                case NORTH: {
                    this.A = new Vector3d(cuboid.Max.X, cuboid.Max.Y, cuboid.Min.Z);
                    this.B = new Vector3d(cuboid.Max.X, cuboid.Min.Y, cuboid.Min.Z);
                    this.C = new Vector3d(cuboid.Min.X, cuboid.Min.Y, cuboid.Min.Z);
                    this.D = new Vector3d(cuboid.Min.X, cuboid.Max.Y, cuboid.Min.Z);
                    break;
                }
                case SOUTH: {
                    this.A = new Vector3d(cuboid.Min.X, cuboid.Max.Y, cuboid.Max.Z);
                    this.B = new Vector3d(cuboid.Min.X, cuboid.Min.Y, cuboid.Max.Z);
                    this.C = new Vector3d(cuboid.Max.X, cuboid.Min.Y, cuboid.Max.Z);
                    this.D = new Vector3d(cuboid.Max.X, cuboid.Max.Y, cuboid.Max.Z);
                }
            }
        }

        public Vector3d getVertexByIndex(int index) {
            switch (index) {
                case 0: {
                    return this.A;
                }
                case 1: {
                    return this.B;
                }
                case 2: {
                    return this.C;
                }
                case 3: {
                    return this.D;
                }
            }
            throw new IllegalArgumentException("Invalid vertex index");
        }

        public Vector3f getNormal() {
            Vec3i n = this.FACING.getNormal();
            return new Vector3f((float)n.getX(), (float)n.getY(), (float)n.getZ());
        }

        public boolean equals(Object other) {
            if (other instanceof Face) {
                Face f = (Face)other;
                return this.FACING == f.FACING && this.A.equals(f.A) && this.B.equals(f.B) && this.C.equals(f.C) && this.D.equals(f.D);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.A, this.B, this.C, this.D, this.FACING);
        }

        public String toString() {
            return String.format("Cuboid.Face [%s]: %s, %s, %s, %s", this.FACING.getName(), this.A.toString(), this.B.toString(), this.C.toString(), this.D.toString());
        }
    }
}

