/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.item.inventory;

import it.zerono.mods.zerocore.lib.data.stack.OperationMode;
import it.zerono.mods.zerocore.lib.item.inventory.IInventorySlot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;

public class InventorySlot
implements IInventorySlot {
    private final IItemHandler _inventory;
    private final int _index;

    public InventorySlot(IItemHandler inventory, int slotIndex) {
        this._inventory = inventory;
        this._index = slotIndex;
    }

    @Override
    public int getIndex() {
        return this._index;
    }

    @Override
    public ItemStack getStackInSlot() {
        return this._inventory.getStackInSlot(this.getIndex());
    }

    @Override
    public void setStackInSlot(ItemStack stack) {
        if (this._inventory instanceof IItemHandlerModifiable) {
            ((IItemHandlerModifiable)this._inventory).setStackInSlot(this.getIndex(), stack);
        }
    }

    @Override
    public ItemStack insertStack(ItemStack stack, OperationMode mode) {
        return this._inventory.insertItem(this.getIndex(), stack, mode.simulate());
    }

    @Override
    public ItemStack extractStack(int amount, OperationMode mode) {
        return this._inventory.extractItem(this.getIndex(), amount, mode.simulate());
    }

    @Override
    public boolean canInsertStack(ItemStack stack) {
        ItemStack remainder = this._inventory.insertItem(this.getIndex(), stack, true);
        return remainder.isEmpty() || remainder.getCount() < stack.getCount();
    }

    @Override
    public boolean canExtractStack(int amount) {
        ItemStack remainder = this._inventory.extractItem(this.getIndex(), amount, true);
        return !remainder.isEmpty() && amount == remainder.getCount();
    }

    @Override
    public int getSlotLimit(ItemStack stack) {
        ItemStack current = this.getStackInSlot();
        return current.isEmpty() ? stack.getMaxStackSize() : current.getMaxStackSize();
    }
}

