/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.justdirethings.datagen.recipes;

import com.direwolf20.justdirethings.setup.Registration;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.IdMap;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class FluidDropRecipe
implements CraftingRecipe {
    private final ResourceLocation id;
    protected final BlockState input;
    protected final BlockState output;
    protected final Item catalyst;

    public FluidDropRecipe(ResourceLocation id, BlockState input, BlockState output, Item catalyst) {
        this.id = id;
        this.input = input;
        this.output = output;
        this.catalyst = catalyst;
    }

    public FluidDropRecipe(ResourceLocation id, BlockState input, BlockState output, Holder<Item> catalyst) {
        this.id = id;
        this.input = input;
        this.output = output;
        this.catalyst = (Item)catalyst.value();
    }

    public RecipeType<?> getType() {
        return Registration.FLUID_DROP_RECIPE_TYPE.get();
    }

    public boolean matches(BlockState blockState, ItemStack catalystStack) {
        if (!catalystStack.is(this.catalyst)) {
            return false;
        }
        return blockState.getFluidState().is(this.input.getFluidState().getType()) && blockState.getFluidState().isSource();
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public BlockState getOutput() {
        return this.output;
    }

    public BlockState getInput() {
        return this.input;
    }

    public Item getCatalyst() {
        return this.catalyst;
    }

    public Holder<Item> getCatalystHolder() {
        return this.catalyst == null ? null : this.catalyst.builtInRegistryHolder();
    }

    public CraftingBookCategory category() {
        return CraftingBookCategory.MISC;
    }

    public ItemStack getResultItem(HolderLookup.Provider provider) {
        return ItemStack.EMPTY;
    }

    public boolean isSpecial() {
        return true;
    }

    public boolean matches(CraftingInput p_346065_, Level p_345375_) {
        return false;
    }

    public ItemStack assemble(CraftingInput p_345149_, HolderLookup.Provider p_346030_) {
        return ItemStack.EMPTY;
    }

    public boolean canCraftInDimensions(int pWidth, int pHeight) {
        return false;
    }

    public RecipeSerializer<?> getSerializer() {
        return Registration.FLUID_DROP_RECIPE_SERIALIZER.get();
    }

    public static class Serializer
    implements RecipeSerializer<FluidDropRecipe> {
        private static final ResourceLocation NAME = ResourceLocation.fromNamespaceAndPath((String)"justdirethings", (String)"fluiddrop");
        private static final MapCodec<FluidDropRecipe> CODEC = RecordCodecBuilder.mapCodec(p_311734_ -> p_311734_.group((App)ResourceLocation.CODEC.fieldOf("id").forGetter(p_301134_ -> p_301134_.id), (App)BlockState.CODEC.fieldOf("input").forGetter(p_301135_ -> p_301135_.input), (App)BlockState.CODEC.fieldOf("output").forGetter(p_301136_ -> p_301136_.output), (App)ItemStack.ITEM_NON_AIR_CODEC.fieldOf("catalyst").forGetter(p_301137_ -> p_301137_.catalyst.builtInRegistryHolder())).apply((Applicative)p_311734_, FluidDropRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, FluidDropRecipe> STREAM_CODEC = StreamCodec.composite((StreamCodec)ResourceLocation.STREAM_CODEC, FluidDropRecipe::getId, (StreamCodec)ByteBufCodecs.idMapper((IdMap)Block.BLOCK_STATE_REGISTRY), FluidDropRecipe::getInput, (StreamCodec)ByteBufCodecs.idMapper((IdMap)Block.BLOCK_STATE_REGISTRY), FluidDropRecipe::getOutput, (StreamCodec)ByteBufCodecs.holderRegistry((ResourceKey)Registries.ITEM), FluidDropRecipe::getCatalystHolder, FluidDropRecipe::new);

        public MapCodec<FluidDropRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, FluidDropRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

