/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.tank.blocks;

import com.mojang.serialization.DynamicOps;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import mcjty.lib.api.container.DefaultContainerProvider;
import mcjty.lib.api.container.ItemInventory;
import mcjty.lib.api.fluids.ItemFluids;
import mcjty.lib.blocks.BaseBlock;
import mcjty.lib.blocks.RotationType;
import mcjty.lib.builder.BlockBuilder;
import mcjty.lib.builder.InfoLine;
import mcjty.lib.builder.TooltipBuilder;
import mcjty.lib.compat.theoneprobe.TOPDriver;
import mcjty.lib.container.ContainerFactory;
import mcjty.lib.container.GenericItemHandler;
import mcjty.lib.container.SlotDefinition;
import mcjty.lib.setup.Registration;
import mcjty.lib.tileentity.Cap;
import mcjty.lib.tileentity.CapType;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.varia.CustomTank;
import mcjty.rftoolsbase.tools.ManualHelper;
import mcjty.rftoolsutility.compat.RFToolsUtilityTOPDriver;
import mcjty.rftoolsutility.modules.tank.TankConfiguration;
import mcjty.rftoolsutility.modules.tank.TankModule;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.client.model.data.ModelProperty;
import net.neoforged.neoforge.common.util.Lazy;
import net.neoforged.neoforge.fluids.FluidActionResult;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;

public class TankTE
extends GenericTileEntity {
    public static final int SLOT_FILTER = 0;
    public static final ModelProperty<Integer> AMOUNT = new ModelProperty();
    public static final ModelProperty<Fluid> FLUID = new ModelProperty();
    private int amount = -1;
    private Fluid clientFluid = null;
    public static final Lazy<ContainerFactory> CONTAINER_FACTORY = Lazy.of(() -> new ContainerFactory(1).slot(SlotDefinition.specific(s -> s.getItem() instanceof BucketItem).in().out(), 0, 151, 10).playerSlots(10, 70));
    private final GenericItemHandler items = GenericItemHandler.create((GenericTileEntity)this, CONTAINER_FACTORY).itemValid((slot, stack) -> stack.getItem() instanceof BucketItem).onUpdate((slot, stack) -> this.updateFilterFluid((ItemStack)stack)).build();
    @Cap(type=CapType.ITEMS_AUTOMATION)
    private static final Function<TankTE, GenericItemHandler> ITEM_HANDLER = te -> te.items;
    private final CustomTank fluidHandler = this.createFluidHandler();
    @Cap(type=CapType.FLUIDS)
    private static final Function<TankTE, CustomTank> FLUID_HANDLER = te -> te.fluidHandler;
    @Cap(type=CapType.CONTAINER)
    private static final Function<TankTE, MenuProvider> SCREEN_CAP = be -> new DefaultContainerProvider("Tank").containerSupplier(DefaultContainerProvider.container(TankModule.CONTAINER_TANK, CONTAINER_FACTORY, (GenericTileEntity)be)).itemHandler(() -> be.items).setupSync((GenericTileEntity)be);
    private Fluid filterFluid = null;

    public TankTE(BlockPos pos, BlockState state) {
        super((BlockEntityType)TankModule.TANK.be().get(), pos, state);
    }

    public static BaseBlock createBlock() {
        return new BaseBlock(new BlockBuilder().topDriver((TOPDriver)RFToolsUtilityTOPDriver.DRIVER).tileEntitySupplier(TankTE::new).manualEntry(ManualHelper.create((String)"rftoolsbase:machines/tank")).info(new InfoLine[]{TooltipBuilder.key((String)"message.rftoolsutility.shiftmessage")}).infoShift(new InfoLine[]{TooltipBuilder.header(), TooltipBuilder.parameter((String)"contents", stack -> TankTE.getFluidString(stack) + " (" + Integer.toString((Integer)TankConfiguration.MAXCAPACITY.get()) + " mb)")})){

            public RotationType getRotationType() {
                return RotationType.NONE;
            }
        };
    }

    private static String getFluidString(ItemStack stack) {
        List list;
        ItemFluids data = (ItemFluids)stack.get((Supplier)Registration.ITEM_FLUIDS);
        if (data != null && !(list = data.fluids()).isEmpty()) {
            FluidStack fluid = (FluidStack)list.get(0);
            return fluid.getAmount() + "mb " + fluid.getHoverName().getString();
        }
        return "<empty>";
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        this.amount = tag.getInt("level");
        this.fluidHandler.load(tag, "tank", provider);
        this.items.load(tag, "items", provider);
    }

    public void saveAdditional(@Nonnull CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        tag.putInt("level", this.amount);
        this.fluidHandler.save(tag, "tank", provider);
        this.items.save(tag, "items", provider);
    }

    protected void applyImplicitComponents(BlockEntity.DataComponentInput input) {
        super.applyImplicitComponents(input);
        this.fluidHandler.applyImplicitComponents((ItemFluids)input.get((Supplier)Registration.ITEM_FLUIDS));
        this.items.applyImplicitComponents((ItemInventory)input.get((Supplier)Registration.ITEM_INVENTORY));
    }

    protected void collectImplicitComponents(DataComponentMap.Builder builder) {
        super.collectImplicitComponents(builder);
        this.fluidHandler.collectImplicitComponents(builder);
        this.items.collectImplicitComponents(builder);
    }

    public void loadClientDataFromNBT(CompoundTag tag, HolderLookup.Provider provider) {
        ItemFluids.ITEM_FLUIDS_CODEC.decode((DynamicOps)NbtOps.INSTANCE, (Object)tag.get("ItemFluids")).result().ifPresent(fluids -> {
            List list = ((ItemFluids)fluids.getFirst()).fluids();
            if (!list.isEmpty()) {
                this.fluidHandler.setFluid((FluidStack)list.getFirst());
            }
        });
        this.clientFluid = this.fluidHandler.getFluid().getFluid();
        this.amount = tag.getInt("level");
    }

    public void saveClientDataToNBT(CompoundTag tag, HolderLookup.Provider provider) {
        ItemFluids itemFluids = new ItemFluids(List.of(this.fluidHandler.getFluid()));
        ItemFluids.ITEM_FLUIDS_CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)itemFluids).result().ifPresent(nbt -> tag.put("ItemFluids", nbt));
        tag.putInt("level", this.amount);
    }

    private void updateFilterFluid(ItemStack stack) {
        this.filterFluid = FluidUtil.getFluidContained((ItemStack)stack).map(FluidStack::getFluid).orElse(null);
    }

    public InteractionResult onBlockActivated(BlockState state, Player player, InteractionHand hand, BlockHitResult result) {
        if (!this.level.isClientSide) {
            ItemStack heldItem = player.getItemInHand(hand);
            FluidActionResult fillResult = FluidUtil.tryEmptyContainerAndStow((ItemStack)heldItem, (IFluidHandler)this.fluidHandler, null, (int)Integer.MAX_VALUE, (Player)player, (boolean)true);
            if (fillResult.isSuccess()) {
                player.setItemInHand(hand, fillResult.getResult());
                return InteractionResult.SUCCESS;
            }
            fillResult = FluidUtil.tryFillContainerAndStow((ItemStack)heldItem, (IFluidHandler)this.fluidHandler, null, (int)Integer.MAX_VALUE, (Player)player, (boolean)true);
            if (fillResult.isSuccess()) {
                player.setItemInHand(hand, fillResult.getResult());
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.PASS;
        }
        return InteractionResult.PASS;
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket packet, HolderLookup.Provider provider) {
        int oldLevel = this.computeLevel(this.fluidHandler);
        super.onDataPacket(net, packet, provider);
        this.amount = this.computeLevel(this.fluidHandler);
        if (oldLevel != this.amount || !this.fluidHandler.getFluid().getFluid().equals(this.clientFluid)) {
            this.clientFluid = this.fluidHandler.getFluid().getFluid();
            this.requestModelDataUpdate();
            this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
        }
    }

    private void updateLevel(CustomTank tank) {
        this.markDirtyQuick();
        int newlevel = this.computeLevel(tank);
        if (this.amount != newlevel || !tank.getFluid().getFluid().equals(this.clientFluid)) {
            this.amount = newlevel;
            this.clientFluid = tank.getFluid().getFluid();
            this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
        }
    }

    private int computeLevel(CustomTank tank) {
        int amount = tank.getFluidAmount();
        if (amount <= 0) {
            return 0;
        }
        int total = 8 * amount / tank.getCapacity() + 1;
        if (total > 8) {
            total = 8;
        }
        return total;
    }

    @Nonnull
    private CustomTank createFluidHandler() {
        return new CustomTank((Integer)TankConfiguration.MAXCAPACITY.get()){

            protected void onContentsChanged() {
                TankTE.this.updateLevel(this);
            }

            public boolean isFluidValid(FluidStack stack) {
                if (TankTE.this.filterFluid == null) {
                    return true;
                }
                return TankTE.this.filterFluid == stack.getFluid();
            }
        };
    }

    @Nonnull
    public ModelData getModelData() {
        return ModelData.builder().with(AMOUNT, (Object)this.amount).with(FLUID, (Object)this.clientFluid).build();
    }
}

