/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util;

import java.lang.ref.WeakReference;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.world.level.block.entity.BlockEntity;

public abstract class MultiblockCapability<T> {
    public static <BE extends BlockEntity, T> MultiblockCapability<T> make(BE owner, Function<BE, MultiblockCapability<T>> getCap, Function<BE, BE> getMaster, T ownValue) {
        return new Impl<T, BE>(getCap, getMaster, owner, ownValue);
    }

    @Nullable
    public abstract T get();

    private static final class Impl<T, BE extends BlockEntity>
    extends MultiblockCapability<T> {
        private final BE owner;
        private final T ownValue;
        private final Function<BE, MultiblockCapability<T>> getCap;
        private final Function<BE, BE> getMaster;
        private WeakReference<BE> cachedMaster = new WeakReference<Object>(null);

        public Impl(Function<BE, MultiblockCapability<T>> getCap, Function<BE, BE> getMaster, BE owner, T ownValue) {
            this.owner = owner;
            this.getCap = getCap;
            this.getMaster = getMaster;
            this.ownValue = ownValue;
        }

        @Override
        @Nullable
        public T get() {
            BlockEntity master = (BlockEntity)this.cachedMaster.get();
            if (master == null || master.isRemoved()) {
                master = (BlockEntity)this.getMaster.apply(this.owner);
            }
            if (master == this.owner) {
                return this.ownValue;
            }
            if (master != null) {
                return this.getCap.apply(master).get();
            }
            return null;
        }
    }
}

